LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;
USE WORK.enkrip_pack.ALL;

ENTITY AddRoundKey IS
	PORT(kunci_i  : IN tipe_kunci;
		 state_i  : IN tipe_state;
		 sel_i    : IN std_logic;
		 state_o  : OUT tipe_state;
		 data_o   : OUT bit128
	);
END AddRoundKey;

ARCHITECTURE AddRoundKey_RTL of AddRoundKey IS

SIGNAL temp		: tipe_state;
SIGNAL nol 		: bit8;

BEGIN

	temp <= ADD_ROUNDKEY(kunci_i, state_i);
	state_o <= temp;
	nol <= (OTHERS => '0');

	A: FOR kolom IN 0 TO 3 GENERATE
		B: FOR baris IN 0 TO 3 GENERATE
	 		    data_o((127-(kolom*32 + baris*8)) DOWNTO
   			           (128-(kolom*32 + (baris+1)*8))) <= temp(baris)(kolom) WHEN sel_i = '1' ELSE nol;		
			 END GENERATE;
		END GENERATE;
		
END AddRoundKey_RTL;














































